# ──────────────────────────────────────────────────────────────────────────────
# apps/wp_invoices/models.py
# ──────────────────────────────────────────────────────────────────────────────
from __future__ import annotations
from sqlalchemy import Column, Integer, String, Numeric, Date, ForeignKey
from sqlalchemy.orm import relationship
from apps.wp_invoices.db.base import Base

class Invoice(Base):
    __tablename__ = "invoices"
    id = Column(Integer, primary_key=True)
    supplier_name = Column(String(255))
    supplier_abn = Column(String(64))
    invoice_number = Column(String(128), index=True)
    invoice_date = Column(String(32))  # mantener string por ahora (flexible)
    payment_method = Column(String(64))
    file_path = Column(String(512), nullable=True)
    # Totales
    tendered_total = Column(Numeric(12, 2))
    items_sum = Column(Numeric(12, 2))
    gst = Column(Numeric(12, 2))
    grand_total = Column(Numeric(12, 2))

    items = relationship("InvoiceItem", back_populates="invoice", cascade="all, delete-orphan")


class InvoiceItem(Base):
    __tablename__ = "invoice_items"
    id = Column(Integer, primary_key=True)
    invoice_id = Column(Integer, ForeignKey("invoices.id", ondelete="CASCADE"), index=True)

    sku = Column(String(128))
    description = Column(String(1024))
    qty = Column(Numeric(12, 3))
    unit_price = Column(Numeric(12, 4))
    line_total = Column(Numeric(12, 2))

    invoice = relationship("Invoice", back_populates="items")