from flask import Flask
from apps.wp_invoices.api.blueprint import wp_invoices_bp

def create_wp_invoices_app() -> Flask:
    app = Flask(__name__)
    app.register_blueprint(wp_invoices_bp)
    return app

# Este objeto es lo que otros módulos (p.ej. resolve_routes.py) pueden importar
def register_wp_invoices(app: Flask):
    """Registra el blueprint wp_invoices en una app existente."""
    app.register_blueprint(wp_invoices_bp)

# Nota: en resolve_routes.py podrías usar:
# from apps.wp_invoices import register_wp_invoices
# register_wp_invoices(app)
# O directamente:
# from apps.wp_invoices.api.blueprint import wp_invoices_bp
# app.register_blueprint(wp_invoices_bp)