"""wp_invoices schema v1

Revision ID: 6dc0a6517c68
Revises: 67b7d0a9f98e
Create Date: 2025-11-04 03:30:02.634982

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '6dc0a6517c68'
down_revision: Union[str, None] = '67b7d0a9f98e'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('invoices',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('supplier_name', sa.String(length=255), nullable=True),
    sa.Column('supplier_abn', sa.String(length=64), nullable=True),
    sa.Column('invoice_number', sa.String(length=128), nullable=True),
    sa.Column('invoice_date', sa.String(length=32), nullable=True),
    sa.Column('payment_method', sa.String(length=64), nullable=True),
    sa.Column('tendered_total', sa.Numeric(precision=12, scale=2), nullable=True),
    sa.Column('items_sum', sa.Numeric(precision=12, scale=2), nullable=True),
    sa.Column('gst', sa.Numeric(precision=12, scale=2), nullable=True),
    sa.Column('grand_total', sa.Numeric(precision=12, scale=2), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_invoices_invoice_number'), 'invoices', ['invoice_number'], unique=False)
    op.create_table('invoice_items',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('invoice_id', sa.Integer(), nullable=True),
    sa.Column('sku', sa.String(length=128), nullable=True),
    sa.Column('description', sa.String(length=1024), nullable=True),
    sa.Column('qty', sa.Numeric(precision=12, scale=3), nullable=True),
    sa.Column('unit_price', sa.Numeric(precision=12, scale=4), nullable=True),
    sa.Column('line_total', sa.Numeric(precision=12, scale=2), nullable=True),
    sa.ForeignKeyConstraint(['invoice_id'], ['invoices.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_invoice_items_invoice_id'), 'invoice_items', ['invoice_id'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_invoice_items_invoice_id'), table_name='invoice_items')
    op.drop_table('invoice_items')
    op.drop_index(op.f('ix_invoices_invoice_number'), table_name='invoices')
    op.drop_table('invoices')
    # ### end Alembic commands ###
